<?php
function get_configuration_from_db($argv) {
	/* check number of arguments */
	if(count($argv) != 4) {
		echo "Usage: get_configuration_from_db DB_HOST DB_USERNAME DB_PASSWORD KEY\n";
		exit(1);
	}

	/* fetch arguments */
	$db_host = escapeshellarg($argv[0]);
	$db_username = escapeshellarg($argv[1]);
	$db_password = escapeshellarg($argv[2]);
	$key = escapeshellarg($argv[3]);

	/* execute main function */
	$connection = pg_connect("host=$db_host dbname=dtasdb user=$db_username password=$db_password");
	if($connection == false) {
		echo "ConnectToDbFail: host='$db_host', user='$db_username'" ;
		exit(1);
	}

	$queryString = sprintf("SELECT value FROM tb_global_setting WHERE key=%s", $key);
	$queryResult = pg_query($queryString);
	if($queryResult == false) {
		echo 'pg_query: ' . pg_last_error();
        pg_close($connection);
		exit(1);
	}

	$result = pg_fetch_assoc($queryResult);
	echo $result['value'];
    
    pg_close($connection);
	exit(0);
}

